/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot;

import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.FileInputStream;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.cache2k.event.CacheEntryExpiredListener;
import org.cache2k.event.CacheEntryOperationListener;
import xyz.gianlu.librespot.AbsConfiguration;
import xyz.gianlu.librespot.handler.ArtistAboutHandler;
import xyz.gianlu.librespot.handler.ArtistInfoHandler;
import xyz.gianlu.librespot.handler.ArtistInsightsHandler;
import xyz.gianlu.librespot.handler.PlayCountHandler;
import xyz.gianlu.librespot.mercury.MercuryClient;

public class HTTPServer {
    private AbsConfiguration conf;
    private MercuryClient mercuryClient;
    public HttpsServer httpsServer;
    public HttpServer httpServer;
    public ThreadPoolExecutor threadPoolExecutor;
    private Cache<String, String> cache;

    public HTTPServer(AbsConfiguration conf, MercuryClient mc) {
        this.conf = conf;
        this.mercuryClient = mc;
        this.cache = new Cache2kBuilder<String, String>(){}.name("cache").entryCapacity(10000L).expireAfterWrite(10L, TimeUnit.MINUTES).resilienceDuration(5L, TimeUnit.SECONDS).addListener((CacheEntryOperationListener)((CacheEntryExpiredListener)(cache, cacheEntry) -> cache.remove((Object)((String)cacheEntry.getKey())))).build();
    }

    public void start() {
        try {
            InetSocketAddress address = new InetSocketAddress(System.getenv("PORT") != null ? Integer.parseInt(System.getenv("PORT")) : this.conf.port());
            if (this.conf.enableHttps()) {
                this.httpsServer = HttpsServer.create(address, 0);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                char[] password = Objects.requireNonNull(this.conf.httpsKsPass()).toCharArray();
                KeyStore ks = KeyStore.getInstance("JKS");
                FileInputStream fis = new FileInputStream(Objects.requireNonNull(this.conf.httpsKs()));
                ks.load(fis, password);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, password);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(ks);
                sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                this.httpsServer.setHttpsConfigurator(new HttpsConfigurator(sslContext){

                    @Override
                    public void configure(HttpsParameters params) {
                        try {
                            SSLContext context = this.getSSLContext();
                            SSLEngine engine = context.createSSLEngine();
                            params.setNeedClientAuth(false);
                            params.setCipherSuites(engine.getEnabledCipherSuites());
                            params.setProtocols(engine.getEnabledProtocols());
                            SSLParameters sslParameters = context.getSupportedSSLParameters();
                            params.setSSLParameters(sslParameters);
                        }
                        catch (Exception ex) {
                            System.out.println("Failed to create HTTPS port");
                            ex.printStackTrace();
                        }
                    }
                });
                this.threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(10);
                this.httpsServer.createContext(this.conf.albumEndpoint(), new PlayCountHandler(this.mercuryClient, this.cache));
                this.httpsServer.createContext(this.conf.artistEndpoint(), new ArtistInfoHandler(this.mercuryClient, this.cache));
                this.httpsServer.createContext(this.conf.artistAboutEndpoint(), new ArtistAboutHandler(this.mercuryClient, this.cache));
                this.httpsServer.createContext(this.conf.artistInsightsEndpoint(), new ArtistInsightsHandler(this.mercuryClient, this.cache));
                this.httpsServer.setExecutor(this.threadPoolExecutor);
                this.httpsServer.start();
                System.out.println("Listening on port " + this.httpsServer.getAddress().getPort());
            } else {
                this.httpServer = HttpServer.create(address, 0);
                this.threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(10);
                this.httpServer.createContext(this.conf.albumEndpoint(), new PlayCountHandler(this.mercuryClient, this.cache));
                this.httpServer.createContext(this.conf.artistEndpoint(), new ArtistInfoHandler(this.mercuryClient, this.cache));
                this.httpServer.createContext(this.conf.artistAboutEndpoint(), new ArtistAboutHandler(this.mercuryClient, this.cache));
                this.httpServer.createContext(this.conf.artistInsightsEndpoint(), new ArtistInsightsHandler(this.mercuryClient, this.cache));
                this.httpServer.setExecutor(this.threadPoolExecutor);
                this.httpServer.start();
                System.out.println("Listening on port " + this.httpServer.getAddress().getPort());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

