/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot.core;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.protobuf.ByteString;
import com.spotify.Authentication;
import com.spotify.Keyexchange;
import com.spotify.connectstate.Connect;
import com.spotify.explicit.ExplicitContentPubsub;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import xyz.gianlu.librespot.AbsConfiguration;
import xyz.gianlu.librespot.Version;
import xyz.gianlu.librespot.common.NameThreadFactory;
import xyz.gianlu.librespot.common.Utils;
import xyz.gianlu.librespot.core.ApResolver;
import xyz.gianlu.librespot.crypto.CipherPair;
import xyz.gianlu.librespot.crypto.DiffieHellman;
import xyz.gianlu.librespot.crypto.Packet;
import xyz.gianlu.librespot.mercury.MercuryClient;
import xyz.gianlu.librespot.mercury.SubListener;

public final class Session
implements Closeable,
SubListener {
    private static final Logger LOGGER = Logger.getLogger(Session.class);
    private static final byte[] serverKey = new byte[]{-84, -32, 70, 11, -1, -62, 48, -81, -12, 107, -2, -61, -65, -65, -122, 61, -95, -111, -58, -52, 51, 108, -109, -95, 79, -77, -80, 22, 18, -84, -84, 106, -15, -128, -25, -10, 20, -39, 66, -99, -66, 46, 52, 102, 67, -29, 98, -46, 50, 122, 26, 13, -110, 59, -82, -35, 20, 2, -79, -127, 85, 5, 97, 4, -43, 44, -106, -92, 76, 30, -52, 2, 74, -44, -78, 12, 0, 31, 23, -19, -62, 47, -60, 53, 33, -56, -16, -53, -82, -46, -83, -41, 43, 15, -99, -77, -59, 50, 26, 42, -2, 89, -13, 90, 13, -84, 104, -15, -6, 98, 30, -5, 44, -115, 12, -73, 57, 45, -110, 71, -29, -41, 53, 26, 109, -67, 36, -62, -82, 37, 91, -120, -1, -85, 115, 41, -118, 11, -52, -51, 12, 88, 103, 49, -119, -24, -67, 52, -128, 120, 74, 95, -55, 107, -119, -99, -107, 107, -4, -122, -41, 79, 51, -90, 120, 23, -106, -55, -61, 45, 13, 50, -91, -85, -51, 5, 39, -30, -9, 16, -93, -106, 19, -60, 47, -103, -64, 39, -65, -19, 4, -100, 60, 39, 88, 4, -74, -78, 25, -7, -63, 47, 2, -23, 72, 99, -20, -95, -74, 66, -96, -99, 72, 37, -8, -77, -99, -48, -24, 106, -7, 72, 77, -95, -62, -70, -122, 48, 66, -22, -99, -77, 8, 108, 25, 14, 72, -77, -99, 102, -21, 0, 6, -94, 90, -18, -95, 27, 19, -121, 60, -41, 25, -26, 85, -67};
    private final DiffieHellman keys;
    private final Inner inner;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new NameThreadFactory(r -> "session-scheduler-" + r.hashCode()));
    private final ExecutorService executorService = Executors.newCachedThreadPool(new NameThreadFactory(r -> "handle-packet-" + r.hashCode()));
    private final AtomicBoolean authLock = new AtomicBoolean(false);
    private final List<CloseListener> closeListeners = Collections.synchronizedList(new ArrayList());
    private final List<ReconnectionListener> reconnectionListeners = Collections.synchronizedList(new ArrayList());
    private final Map<String, String> userAttributes = Collections.synchronizedMap(new HashMap());
    private ConnectionHolder conn;
    private volatile CipherPair cipherPair;
    private Receiver receiver;
    private Authentication.APWelcome apWelcome = null;
    private MercuryClient mercuryClient;
    private String countryCode = null;
    private volatile boolean closed = false;
    private volatile ScheduledFuture<?> scheduledReconnect = null;

    private Session(Inner inner, String addr) throws IOException {
        this.inner = inner;
        this.keys = new DiffieHellman(inner.random);
        this.conn = ConnectionHolder.create(addr);
        LOGGER.info(String.format("Created new session! {deviceId: %s, ap: %s} ", inner.deviceId, addr));
    }

    @NotNull
    static Session from(@NotNull Inner inner) throws IOException {
        ApResolver.fillPool();
        return new Session(inner, ApResolver.getRandomAccesspoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect() throws IOException, GeneralSecurityException, SpotifyAuthenticationException {
        Accumulator acc = new Accumulator();
        byte[] nonce = new byte[16];
        this.inner.random.nextBytes(nonce);
        Keyexchange.ClientHello clientHello = Keyexchange.ClientHello.newBuilder().setBuildInfo(Version.standardBuildInfo()).addCryptosuitesSupported(Keyexchange.Cryptosuite.CRYPTO_SUITE_SHANNON).setLoginCryptoHello(Keyexchange.LoginCryptoHelloUnion.newBuilder().setDiffieHellman(Keyexchange.LoginCryptoDiffieHellmanHello.newBuilder().setGc(ByteString.copyFrom(this.keys.publicKeyArray())).setServerKeysKnown(1).build()).build()).setClientNonce(ByteString.copyFrom(nonce)).setPadding(ByteString.copyFrom(new byte[]{30})).build();
        byte[] clientHelloBytes = clientHello.toByteArray();
        int length = 6 + clientHelloBytes.length;
        this.conn.out.writeByte(0);
        this.conn.out.writeByte(4);
        this.conn.out.writeInt(length);
        this.conn.out.write(clientHelloBytes);
        this.conn.out.flush();
        acc.writeByte(0);
        acc.writeByte(4);
        acc.writeInt(length);
        acc.write(clientHelloBytes);
        length = this.conn.in.readInt();
        acc.writeInt(length);
        byte[] buffer = new byte[length - 4];
        this.conn.in.readFully(buffer);
        acc.write(buffer);
        acc.dump();
        Keyexchange.APResponseMessage apResponseMessage = Keyexchange.APResponseMessage.parseFrom(buffer);
        byte[] sharedKey = Utils.toByteArray(this.keys.computeSharedKey(apResponseMessage.getChallenge().getLoginCryptoChallenge().getDiffieHellman().getGs().toByteArray()));
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = factory.generatePublic(new RSAPublicKeySpec(new BigInteger(1, serverKey), BigInteger.valueOf(65537L)));
        Signature sig = Signature.getInstance("SHA1withRSA");
        sig.initVerify(publicKey);
        sig.update(apResponseMessage.getChallenge().getLoginCryptoChallenge().getDiffieHellman().getGs().toByteArray());
        if (!sig.verify(apResponseMessage.getChallenge().getLoginCryptoChallenge().getDiffieHellman().getGsSignature().toByteArray())) {
            throw new GeneralSecurityException("Failed signature check!");
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream(100);
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(new SecretKeySpec(sharedKey, "HmacSHA1"));
        for (int i = 1; i < 6; ++i) {
            mac.update(acc.array());
            mac.update(new byte[]{(byte)i});
            data.write(mac.doFinal());
            mac.reset();
        }
        byte[] dataArray = data.toByteArray();
        mac = Mac.getInstance("HmacSHA1");
        mac.init(new SecretKeySpec(Arrays.copyOfRange(dataArray, 0, 20), "HmacSHA1"));
        mac.update(acc.array());
        byte[] challenge = mac.doFinal();
        Keyexchange.ClientResponsePlaintext clientResponsePlaintext = Keyexchange.ClientResponsePlaintext.newBuilder().setLoginCryptoResponse(Keyexchange.LoginCryptoResponseUnion.newBuilder().setDiffieHellman(Keyexchange.LoginCryptoDiffieHellmanResponse.newBuilder().setHmac(ByteString.copyFrom(challenge)).build()).build()).setPowResponse(Keyexchange.PoWResponseUnion.newBuilder().build()).setCryptoResponse(Keyexchange.CryptoResponseUnion.newBuilder().build()).build();
        byte[] clientResponsePlaintextBytes = clientResponsePlaintext.toByteArray();
        length = 4 + clientResponsePlaintextBytes.length;
        this.conn.out.writeInt(length);
        this.conn.out.write(clientResponsePlaintextBytes);
        this.conn.out.flush();
        try {
            byte[] scrap = new byte[4];
            this.conn.socket.setSoTimeout(300);
            int read = this.conn.in.read(scrap);
            if (read == scrap.length) {
                length = scrap[0] << 24 | scrap[1] << 16 | scrap[2] << 8 | scrap[3] & 0xFF;
                byte[] payload = new byte[length - 4];
                this.conn.in.readFully(payload);
                Keyexchange.APLoginFailed failed = Keyexchange.APResponseMessage.parseFrom(payload).getLoginFailed();
                throw new SpotifyAuthenticationException(failed);
            }
            if (read > 0) {
                throw new IllegalStateException("Read unknown data!");
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
        }
        finally {
            this.conn.socket.setSoTimeout(0);
        }
        AtomicBoolean atomicBoolean = this.authLock;
        synchronized (atomicBoolean) {
            this.cipherPair = new CipherPair(Arrays.copyOfRange(data.toByteArray(), 20, 52), Arrays.copyOfRange(data.toByteArray(), 52, 84));
            this.authLock.set(true);
        }
        LOGGER.info("Connected successfully!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authenticate(@NotNull Authentication.LoginCredentials credentials) throws IOException, GeneralSecurityException, SpotifyAuthenticationException, MercuryClient.MercuryException {
        this.authenticatePartial(credentials, false);
        AtomicBoolean atomicBoolean = this.authLock;
        synchronized (atomicBoolean) {
            this.mercuryClient = new MercuryClient(this);
            this.authLock.set(false);
            this.authLock.notifyAll();
        }
        LOGGER.info(String.format("Authenticated as %s!", this.apWelcome.getCanonicalUsername()));
        this.mercuryClient.interestedIn("spotify:user:attributes:update", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticatePartial(@NotNull Authentication.LoginCredentials credentials, boolean removeLock) throws IOException, GeneralSecurityException, SpotifyAuthenticationException {
        if (this.cipherPair == null) {
            throw new IllegalStateException("Connection not established!");
        }
        Authentication.ClientResponseEncrypted clientResponseEncrypted = Authentication.ClientResponseEncrypted.newBuilder().setLoginCredentials(credentials).setSystemInfo(Authentication.SystemInfo.newBuilder().setOs(Authentication.Os.OS_UNKNOWN).setCpuFamily(Authentication.CpuFamily.CPU_UNKNOWN).setSystemInformationString(Version.systemInfoString()).setDeviceId(this.inner.deviceId).build()).setVersionString(Version.versionString()).build();
        this.sendUnchecked(Packet.Type.Login, clientResponseEncrypted.toByteArray());
        Packet packet = this.cipherPair.receiveEncoded(this.conn.in);
        if (packet.is(Packet.Type.APWelcome)) {
            this.apWelcome = Authentication.APWelcome.parseFrom(packet.payload);
            this.receiver = new Receiver();
            new Thread((Runnable)this.receiver, "session-packet-receiver").start();
            byte[] bytes0x0f = new byte[20];
            this.random().nextBytes(bytes0x0f);
            this.sendUnchecked(Packet.Type.Unknown_0x0f, bytes0x0f);
            ByteBuffer preferredLocale = ByteBuffer.allocate(23);
            preferredLocale.put((byte)0).put((byte)0).put((byte)16).put((byte)0).put((byte)2);
            preferredLocale.put("preferred-locale".getBytes());
            preferredLocale.put(this.inner.configuration.preferredLocale().getBytes());
            this.sendUnchecked(Packet.Type.PreferredLocale, preferredLocale.array());
            if (removeLock) {
                AtomicBoolean atomicBoolean = this.authLock;
                synchronized (atomicBoolean) {
                    this.authLock.set(false);
                    this.authLock.notifyAll();
                }
            }
            if (this.conf().storeCredentials()) {
                ByteString reusable = this.apWelcome.getReusableAuthCredentials();
                Authentication.AuthenticationType reusableType = this.apWelcome.getReusableAuthCredentialsType();
                JsonObject obj = new JsonObject();
                obj.addProperty("username", this.apWelcome.getCanonicalUsername());
                obj.addProperty("credentials", Utils.toBase64(reusable));
                obj.addProperty("type", reusableType.name());
                File storeFile = this.conf().credentialsFile();
                if (storeFile == null) {
                    throw new IllegalArgumentException();
                }
                try (FileOutputStream out = new FileOutputStream(storeFile);){
                    out.write(obj.toString().getBytes());
                }
            }
        } else {
            if (packet.is(Packet.Type.AuthFailure)) {
                throw new SpotifyAuthenticationException(Keyexchange.APLoginFailed.parseFrom(packet.payload));
            }
            throw new IllegalStateException("Unknown CMD 0x" + Integer.toHexString(packet.cmd));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.receiver != null) {
            this.receiver.stop();
            this.receiver = null;
        }
        if (this.mercuryClient != null) {
            this.mercuryClient.close();
            this.mercuryClient = null;
        }
        this.executorService.shutdown();
        this.conn.socket.close();
        Object object = this.authLock;
        synchronized (object) {
            this.apWelcome = null;
            this.cipherPair = null;
            this.closed = true;
        }
        object = this.closeListeners;
        synchronized (object) {
            Iterator<CloseListener> i = this.closeListeners.iterator();
            while (i.hasNext()) {
                i.next().onClosed();
                i.remove();
            }
        }
        LOGGER.info(String.format("Closed session. {deviceId: %s, ap: %s} ", this.inner.deviceId, this.conn.socket.getInetAddress()));
    }

    private void sendUnchecked(Packet.Type cmd, byte[] payload) throws IOException {
        this.cipherPair.sendEncoded(this.conn.out, cmd.val, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitAuthLock() {
        if (this.closed) {
            throw new IllegalStateException("Session is closed!");
        }
        AtomicBoolean atomicBoolean = this.authLock;
        synchronized (atomicBoolean) {
            if (this.cipherPair == null || this.authLock.get()) {
                try {
                    this.authLock.wait();
                }
                catch (InterruptedException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Packet.Type cmd, byte[] payload) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Session is closed!");
        }
        AtomicBoolean atomicBoolean = this.authLock;
        synchronized (atomicBoolean) {
            if (this.cipherPair == null || this.authLock.get()) {
                try {
                    this.authLock.wait();
                }
                catch (InterruptedException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            this.sendUnchecked(cmd, payload);
        }
    }

    @NotNull
    public MercuryClient mercury() {
        this.waitAuthLock();
        if (this.mercuryClient == null) {
            throw new IllegalStateException("Session isn't authenticated!");
        }
        return this.mercuryClient;
    }

    @NotNull
    public Authentication.APWelcome apWelcome() {
        this.waitAuthLock();
        if (this.apWelcome == null) {
            throw new IllegalStateException("Session isn't authenticated!");
        }
        return this.apWelcome;
    }

    @NotNull
    ExecutorService executor() {
        return this.executorService;
    }

    @NotNull
    public Random random() {
        return this.inner.random;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect() {
        List<ReconnectionListener> list = this.reconnectionListeners;
        synchronized (list) {
            this.reconnectionListeners.forEach(ReconnectionListener::onConnectionDropped);
        }
        try {
            if (this.conn != null) {
                this.conn.socket.close();
                this.receiver.stop();
            }
            this.conn = ConnectionHolder.create(ApResolver.getRandomAccesspoint());
            this.connect();
            this.authenticatePartial(Authentication.LoginCredentials.newBuilder().setUsername(this.apWelcome.getCanonicalUsername()).setTyp(this.apWelcome.getReusableAuthCredentialsType()).setAuthData(this.apWelcome.getReusableAuthCredentials()).build(), true);
            LOGGER.info(String.format("Re-authenticated as %s!", this.apWelcome.getCanonicalUsername()));
            list = this.reconnectionListeners;
            synchronized (list) {
                this.reconnectionListeners.forEach(ReconnectionListener::onConnectionEstablished);
            }
        }
        catch (IOException | GeneralSecurityException | SpotifyAuthenticationException ex) {
            this.conn = null;
            LOGGER.error("Failed reconnecting, retrying in 10 seconds...", ex);
            this.scheduler.schedule(this::reconnect, 10L, TimeUnit.SECONDS);
        }
    }

    @NotNull
    public AbsConfiguration conf() {
        return this.inner.configuration;
    }

    private void parseProductInfo(@NotNull InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = dBuilder.parse(in);
        Node products = doc.getElementsByTagName("products").item(0);
        if (products == null) {
            return;
        }
        Node product = products.getChildNodes().item(0);
        if (product == null) {
            return;
        }
        NodeList properties = product.getChildNodes();
        for (int i = 0; i < properties.getLength(); ++i) {
            Node node = properties.item(i);
            this.userAttributes.put(node.getNodeName(), node.getTextContent());
        }
        LOGGER.trace("Parsed product info: " + this.userAttributes);
    }

    @Override
    public void event(@NotNull MercuryClient.Response resp) {
        if (resp.uri.equals("spotify:user:attributes:update")) {
            ExplicitContentPubsub.UserAttributesUpdate attributesUpdate;
            try {
                attributesUpdate = ExplicitContentPubsub.UserAttributesUpdate.parseFrom(resp.payload.stream());
            }
            catch (IOException ex) {
                LOGGER.warn("Failed parsing user attributes update.", ex);
                return;
            }
            for (ExplicitContentPubsub.KeyValuePair pair : attributesUpdate.getPairsList()) {
                this.userAttributes.put(pair.getKey(), pair.getValue());
                LOGGER.trace(String.format("Updated user attribute: %s -> %s", pair.getKey(), pair.getValue()));
            }
        }
    }

    private static class ConnectionHolder {
        final Socket socket;
        final DataInputStream in;
        final DataOutputStream out;

        private ConnectionHolder(@NotNull Socket socket) throws IOException {
            this.socket = socket;
            this.in = new DataInputStream(socket.getInputStream());
            this.out = new DataOutputStream(socket.getOutputStream());
        }

        @NotNull
        static ConnectionHolder create(@NotNull String addr) throws IOException {
            int colon = addr.indexOf(58);
            String apAddr = addr.substring(0, colon);
            int apPort = Integer.parseInt(addr.substring(colon + 1));
            return new ConnectionHolder(new Socket(apAddr, apPort));
        }
    }

    static class Inner {
        final Connect.DeviceType deviceType;
        final String deviceName;
        final SecureRandom random;
        final String deviceId;
        final AbsConfiguration configuration;

        private Inner(Connect.DeviceType deviceType, String deviceName, AbsConfiguration configuration) {
            this.deviceType = deviceType;
            this.deviceName = deviceName;
            this.configuration = configuration;
            this.random = new SecureRandom();
            String configuredDeviceId = configuration.deviceId();
            this.deviceId = configuredDeviceId == null || configuredDeviceId.isEmpty() ? Utils.randomHexString(this.random, 40).toLowerCase() : configuredDeviceId;
        }

        @NotNull
        static Inner from(@NotNull AbsConfiguration configuration) {
            String deviceName = configuration.deviceName();
            if (deviceName == null || deviceName.isEmpty()) {
                throw new IllegalArgumentException("Device name required: " + deviceName);
            }
            Connect.DeviceType deviceType = configuration.deviceType();
            if (deviceType == null) {
                throw new IllegalArgumentException("Device type required!");
            }
            return new Inner(deviceType, deviceName, configuration);
        }
    }

    private static class Accumulator
    extends DataOutputStream {
        private byte[] bytes;

        Accumulator() {
            super(new ByteArrayOutputStream());
        }

        void dump() throws IOException {
            this.bytes = ((ByteArrayOutputStream)this.out).toByteArray();
            this.close();
        }

        @NotNull
        byte[] array() {
            return this.bytes;
        }
    }

    public static class SpotifyAuthenticationException
    extends Exception {
        private SpotifyAuthenticationException(Keyexchange.APLoginFailed loginFailed) {
            super(loginFailed.getErrorCode().name());
        }
    }

    private class Receiver
    implements Runnable {
        private volatile boolean shouldStop = false;

        private Receiver() {
        }

        void stop() {
            this.shouldStop = true;
        }

        @Override
        public void run() {
            block15: while (!this.shouldStop) {
                Packet.Type cmd;
                Packet packet;
                try {
                    packet = Session.this.cipherPair.receiveEncoded(((Session)Session.this).conn.in);
                    cmd = Packet.Type.parse(packet.cmd);
                    if (cmd == null) {
                        LOGGER.info(String.format("Skipping unknown command {cmd: 0x%s, payload: %s}", Integer.toHexString(packet.cmd), Utils.bytesToHex(packet.payload)));
                        continue;
                    }
                }
                catch (IOException | GeneralSecurityException ex) {
                    if (!this.shouldStop) {
                        LOGGER.fatal("Failed reading packet!", ex);
                        Session.this.reconnect();
                    }
                    return;
                }
                if (this.shouldStop) {
                    return;
                }
                switch (cmd) {
                    case Ping: {
                        if (Session.this.scheduledReconnect != null) {
                            Session.this.scheduledReconnect.cancel(true);
                        }
                        Session.this.scheduledReconnect = Session.this.scheduler.schedule(() -> {
                            LOGGER.warn("Socket timed out. Reconnecting...");
                            Session.this.reconnect();
                        }, 125L, TimeUnit.SECONDS);
                        try {
                            Session.this.send(Packet.Type.Pong, packet.payload);
                        }
                        catch (IOException ex) {
                            LOGGER.fatal("Failed sending Pong!", ex);
                        }
                        continue block15;
                    }
                    case PongAck: {
                        continue block15;
                    }
                    case CountryCode: {
                        Session.this.countryCode = new String(packet.payload);
                        LOGGER.info("Received CountryCode: " + Session.this.countryCode);
                        continue block15;
                    }
                    case LicenseVersion: {
                        ByteBuffer licenseVersion = ByteBuffer.wrap(packet.payload);
                        short id = licenseVersion.getShort();
                        if (id != 0) {
                            byte[] buffer = new byte[licenseVersion.get()];
                            licenseVersion.get(buffer);
                            LOGGER.info(String.format("Received LicenseVersion: %d, %s", id, new String(buffer)));
                            continue block15;
                        }
                        LOGGER.info(String.format("Received LicenseVersion: %d", id));
                        continue block15;
                    }
                    case Unknown_0x10: {
                        LOGGER.debug("Received 0x10: " + Utils.bytesToHex(packet.payload));
                        continue block15;
                    }
                    case MercurySub: 
                    case MercuryUnsub: 
                    case MercuryEvent: 
                    case MercuryReq: {
                        Session.this.mercury().dispatch(packet);
                        continue block15;
                    }
                    case AesKey: 
                    case ChannelError: 
                    case ProductInfo: {
                        try {
                            Session.this.parseProductInfo(new ByteArrayInputStream(packet.payload));
                        }
                        catch (IOException | ParserConfigurationException | SAXException ex) {
                            LOGGER.warn("Failed parsing prodcut info!", ex);
                        }
                        continue block15;
                    }
                }
                LOGGER.info("Skipping " + cmd.name());
            }
        }
    }

    public static interface CloseListener {
        public void onClosed();
    }

    public static class Builder {
        private final Inner inner;
        private final AbsConfiguration authConf;
        private Authentication.LoginCredentials loginCredentials = null;
        private String[] args;

        public Builder(@NotNull AbsConfiguration configuration, @Nullable String[] args) {
            this.inner = Inner.from(configuration);
            this.authConf = configuration;
            this.args = args;
        }

        @NotNull
        public Builder userPass(@NotNull String username, @NotNull String password) {
            this.loginCredentials = Authentication.LoginCredentials.newBuilder().setUsername(username).setTyp(Authentication.AuthenticationType.AUTHENTICATION_USER_PASS).setAuthData(ByteString.copyFromUtf8(password)).build();
            return this;
        }

        @NotNull
        public Session create() throws IOException, GeneralSecurityException, SpotifyAuthenticationException, MercuryClient.MercuryException {
            File storeFile;
            if (this.authConf.storeCredentials() && (storeFile = this.authConf.credentialsFile()) != null && storeFile.exists()) {
                JsonObject obj = JsonParser.parseReader(new FileReader(storeFile)).getAsJsonObject();
                this.loginCredentials = Authentication.LoginCredentials.newBuilder().setTyp(Authentication.AuthenticationType.valueOf(obj.get("type").getAsString())).setUsername(obj.get("username").getAsString()).setAuthData(Utils.fromBase64(obj.get("credentials").getAsString())).build();
            }
            if (this.loginCredentials == null) {
                String password;
                String username;
                if (System.getenv("USERNAME") != null && System.getenv("PASSWORD") != null) {
                    username = System.getenv("USERNAME");
                    password = System.getenv("PASSWORD");
                } else {
                    if (this.args.length < 2) {
                        throw new IllegalArgumentException("Missing username and password!");
                    }
                    username = this.args[0];
                    password = this.args[1];
                }
                if (username == null) {
                    throw new IllegalArgumentException("Missing authUsername!");
                }
                if (password == null) {
                    throw new IllegalArgumentException("Missing authPassword!");
                }
                this.userPass(username, password);
            }
            Session session = Session.from(this.inner);
            session.connect();
            session.authenticate(this.loginCredentials);
            return session;
        }
    }

    public static interface ReconnectionListener {
        public void onConnectionDropped();

        public void onConnectionEstablished();
    }
}

