/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot.core;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import xyz.gianlu.librespot.common.AsyncWorker;
import xyz.gianlu.librespot.core.Session;
import xyz.gianlu.librespot.crypto.Packet;

public abstract class PacketsManager
implements AutoCloseable {
    protected final Session session;
    private final ExecutorService executorService;
    private final AsyncWorker<Packet> asyncWorker;

    public PacketsManager(@NotNull Session session, @NotNull String name) {
        this.session = session;
        this.executorService = session.executor();
        this.asyncWorker = new AsyncWorker("pm-" + name, packet -> this.executorService.execute(() -> {
            try {
                this.handle((Packet)packet);
            }
            catch (IOException ex) {
                this.exception(ex);
            }
        }));
    }

    public final void dispatch(@NotNull Packet packet) {
        this.appendToQueue(packet);
    }

    @Override
    public void close() {
        this.asyncWorker.close();
    }

    protected void appendToQueue(@NotNull Packet packet) {
        this.asyncWorker.submit((Object)packet);
    }

    protected abstract void handle(@NotNull Packet var1) throws IOException;

    protected abstract void exception(@NotNull Exception var1);
}

