/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot.mercury.model;

import com.spotify.connectstate.Player;
import com.spotify.context.ContextTrackOuterClass;
import com.spotify.metadata.Metadata;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import xyz.gianlu.librespot.common.Utils;
import xyz.gianlu.librespot.mercury.model.EpisodeId;
import xyz.gianlu.librespot.mercury.model.TrackId;
import xyz.gianlu.librespot.mercury.model.UnsupportedId;

public interface PlayableId {
    @NotNull
    public static PlayableId fromUri(@NotNull String uri) {
        if (!PlayableId.isSupported(uri)) {
            return new UnsupportedId(uri);
        }
        if (TrackId.PATTERN.matcher(uri).matches()) {
            return TrackId.fromUri(uri);
        }
        if (EpisodeId.PATTERN.matcher(uri).matches()) {
            return EpisodeId.fromUri(uri);
        }
        throw new IllegalArgumentException("Unknown uri: " + uri);
    }

    public static boolean canPlaySomething(@NotNull List<ContextTrackOuterClass.ContextTrack> tracks) {
        for (ContextTrackOuterClass.ContextTrack track : tracks) {
            if (!PlayableId.isSupported(track.getUri()) || !PlayableId.shouldPlay(track)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static PlayableId from(@NotNull Player.ProvidedTrack track) {
        return PlayableId.fromUri(track.getUri());
    }

    public static boolean isSupported(@NotNull String uri) {
        return !uri.startsWith("spotify:local:") && !Objects.equals(uri, "spotify:delimiter") && !Objects.equals(uri, "spotify:meta:delimiter");
    }

    public static boolean shouldPlay(@NotNull ContextTrackOuterClass.ContextTrack track) {
        String forceRemoveReasons = track.getMetadataOrDefault("force_remove_reasons", null);
        return forceRemoveReasons == null || forceRemoveReasons.isEmpty();
    }

    @NotNull
    public static PlayableId from(@NotNull ContextTrackOuterClass.ContextTrack track) {
        return PlayableId.fromUri(track.getUri());
    }

    @NotNull
    public static PlayableId from(@NotNull Metadata.Track track) {
        return TrackId.fromHex(Utils.bytesToHex(track.getGid()));
    }

    @NotNull
    public static PlayableId from(@NotNull Metadata.Episode episode) {
        return EpisodeId.fromHex(Utils.bytesToHex(episode.getGid()));
    }

    @NotNull
    public String toString();

    @NotNull
    public byte[] getGid();

    @NotNull
    public String hexId();

    @NotNull
    public String toSpotifyUri();
}

