/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.MapEntry;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import xyz.gianlu.librespot.common.Utils;

public final class ProtobufToJson {
    private ProtobufToJson() {
    }

    @NotNull
    public static JsonObject convert(@NotNull Message message) {
        JsonObject obj = new JsonObject();
        Map<Descriptors.FieldDescriptor, Object> fields = message.getAllFields();
        for (Descriptors.FieldDescriptor descriptor : fields.keySet()) {
            ProtobufToJson.put(obj, descriptor, fields.get(descriptor));
        }
        return obj;
    }

    private static JsonArray array(List<? extends Message> list) {
        JsonArray array = new JsonArray(list.size());
        for (Message message : list) {
            array.add(ProtobufToJson.convert(message));
        }
        return array;
    }

    private static JsonArray arrayOfNumbers(List<? extends Number> list) {
        JsonArray array = new JsonArray(list.size());
        for (Number number : list) {
            array.add(number);
        }
        return array;
    }

    private static JsonArray arrayOfBooleans(List<Boolean> list) {
        JsonArray array = new JsonArray(list.size());
        for (Boolean b : list) {
            array.add(b);
        }
        return array;
    }

    private static JsonObject mapOfStrings(List<MapEntry> map) {
        JsonObject obj = new JsonObject();
        for (MapEntry entry : map) {
            obj.addProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        return obj;
    }

    private static JsonArray arrayOfStrings(List<String> list) {
        JsonArray array = new JsonArray(list.size());
        for (String str : list) {
            array.add(str);
        }
        return array;
    }

    private static JsonArray arrayOfEnums(List<Descriptors.EnumValueDescriptor> list) {
        JsonArray array = new JsonArray(list.size());
        for (Descriptors.EnumValueDescriptor desc : list) {
            array.add(desc.getName());
        }
        return array;
    }

    private static JsonArray arrayOfByteStrings(List<ByteString> list) {
        JsonArray array = new JsonArray(list.size());
        for (ByteString str : list) {
            array.add(Utils.bytesToHex(str));
        }
        return array;
    }

    private static void put(JsonObject json, Descriptors.FieldDescriptor descriptor, Object obj) {
        String key = descriptor.getJsonName();
        switch (descriptor.getJavaType()) {
            case FLOAT: 
            case LONG: 
            case DOUBLE: 
            case INT: {
                if (descriptor.isRepeated()) {
                    json.add(key, ProtobufToJson.arrayOfNumbers((List)obj));
                    break;
                }
                json.addProperty(key, (Number)obj);
                break;
            }
            case BOOLEAN: {
                if (descriptor.isRepeated()) {
                    json.add(key, ProtobufToJson.arrayOfBooleans((List)obj));
                    break;
                }
                json.addProperty(key, (Boolean)obj);
                break;
            }
            case STRING: {
                if (descriptor.isRepeated()) {
                    json.add(key, ProtobufToJson.arrayOfStrings((List)obj));
                    break;
                }
                json.addProperty(key, (String)obj);
                break;
            }
            case BYTE_STRING: {
                if (descriptor.isRepeated()) {
                    json.add(key, ProtobufToJson.arrayOfByteStrings((List)obj));
                    break;
                }
                json.addProperty(key, Utils.bytesToHex((ByteString)obj));
                break;
            }
            case ENUM: {
                if (descriptor.isRepeated()) {
                    json.add(key, ProtobufToJson.arrayOfEnums((List)obj));
                    break;
                }
                json.addProperty(key, ((Descriptors.EnumValueDescriptor)obj).getName());
                break;
            }
            case MESSAGE: {
                if (descriptor.isMapField()) {
                    json.add(key, ProtobufToJson.mapOfStrings((List)obj));
                    break;
                }
                if (descriptor.isRepeated()) {
                    json.add(key, ProtobufToJson.array((List)obj));
                    break;
                }
                json.add(key, ProtobufToJson.convert((Message)obj));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type: " + (Object)((Object)descriptor.getJavaType()));
            }
        }
    }
}

