/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.util;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.cache2k.core.util.InternalClock;
import org.cache2k.core.util.SimpleTimerTask;

public class SimpleTimer {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final InternalClock clock;
    private final TaskQueue queue = new TaskQueue();
    private final TimerThread thread;
    private final InternalClock.TimeReachedJob reachedJob;
    private final Object threadReaper = new Object(){

        protected void finalize() throws Throwable {
            SimpleTimer.this.lock.lock();
            try {
                ((SimpleTimer)SimpleTimer.this).thread.newTasksMayBeScheduled = false;
                SimpleTimer.this.condition.signal();
            }
            finally {
                SimpleTimer.this.lock.unlock();
            }
        }
    };

    public SimpleTimer(InternalClock c, String name, boolean isDaemon) {
        this.clock = c;
        this.thread = new TimerThread(this.clock, this.lock, this.condition, this.queue);
        if (!c.isJobSchedulable()) {
            this.thread.setName(name);
            this.thread.setDaemon(isDaemon);
            this.thread.start();
            this.reachedJob = null;
        } else {
            this.reachedJob = this.clock.createJob(new InternalClock.TimeReachedEvent(){

                @Override
                public void timeIsReached(long _millis) {
                    SimpleTimer.this.timeReachedEvent(_millis);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(SimpleTimerTask task, long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("Illegal execution time.");
        }
        if (!task.schedule()) {
            throw new IllegalStateException("Task already scheduled or cancelled");
        }
        task.executionTime = time;
        this.lock.lock();
        try {
            if (!this.thread.newTasksMayBeScheduled) {
                throw new IllegalStateException("Timer already cancelled.");
            }
            this.queue.add(task);
            if (this.queue.getMin() == task) {
                this.condition.signal();
                if (this.reachedJob != null) {
                    this.clock.schedule(this.reachedJob, time);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void cancel() {
        this.lock.lock();
        try {
            this.thread.newTasksMayBeScheduled = false;
            this.queue.clear();
            this.condition.signal();
            if (this.reachedJob != null) {
                this.clock.disableJob(this.reachedJob);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public int purge() {
        this.lock.lock();
        try {
            int count = 0;
            for (int i = this.queue.size(); i > 0; --i) {
                if (!this.queue.get(i).isCancelled()) continue;
                this.queue.quickRemove(i);
                ++count;
            }
            if (count != 0) {
                this.queue.heapify();
            }
            int n = count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timeReachedEvent(long currentTime) {
        SimpleTimerTask task;
        while (true) {
            this.lock.lock();
            try {
                while (true) {
                    boolean fired;
                    if (this.queue.isEmpty()) {
                        return;
                    }
                    task = this.queue.getMin();
                    long executionTime = task.executionTime;
                    boolean bl = fired = executionTime <= currentTime;
                    if (fired) {
                        this.queue.removeMin();
                        if (!task.execute()) continue;
                    }
                    if (task.isCancelled()) {
                        this.queue.removeMin();
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (task.isScheduled()) break;
            task.run();
        }
        this.clock.schedule(this.reachedJob, task.scheduledExecutionTime());
    }

    class TaskQueue {
        private SimpleTimerTask[] queue = new SimpleTimerTask[128];
        private int size = 0;

        TaskQueue() {
        }

        int size() {
            return this.size;
        }

        void add(SimpleTimerTask task) {
            if (this.size + 1 == this.queue.length) {
                this.queue = Arrays.copyOf(this.queue, 2 * this.queue.length);
            }
            this.queue[++this.size] = task;
            this.fixUp(this.size);
        }

        SimpleTimerTask getMin() {
            return this.queue[1];
        }

        SimpleTimerTask get(int i) {
            return this.queue[i];
        }

        void removeMin() {
            this.queue[1] = this.queue[this.size];
            this.queue[this.size--] = null;
            this.fixDown(1);
        }

        void quickRemove(int i) {
            this.queue[i] = this.queue[this.size];
            this.queue[this.size--] = null;
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        void clear() {
            for (int i = 1; i <= this.size; ++i) {
                this.queue[i] = null;
            }
            this.size = 0;
        }

        private void fixUp(int k) {
            while (k > 1) {
                int j = k >> 1;
                if (this.queue[j].executionTime <= this.queue[k].executionTime) break;
                SimpleTimerTask tmp = this.queue[j];
                this.queue[j] = this.queue[k];
                this.queue[k] = tmp;
                k = j;
            }
        }

        private void fixDown(int k) {
            int j;
            while ((j = k << 1) <= this.size && j > 0) {
                if (j < this.size && this.queue[j].executionTime > this.queue[j + 1].executionTime) {
                    ++j;
                }
                if (this.queue[k].executionTime <= this.queue[j].executionTime) break;
                SimpleTimerTask tmp = this.queue[j];
                this.queue[j] = this.queue[k];
                this.queue[k] = tmp;
                k = j;
            }
        }

        void heapify() {
            for (int i = this.size / 2; i >= 1; --i) {
                this.fixDown(i);
            }
        }
    }

    class TimerThread
    extends Thread {
        boolean newTasksMayBeScheduled = true;
        private TaskQueue queue;
        private final InternalClock clock;
        private final Lock lock;
        private final Condition condition;

        TimerThread(InternalClock clock, Lock l, Condition c, TaskQueue queue) {
            this.lock = l;
            this.condition = c;
            this.clock = clock;
            this.queue = queue;
            this.setPriority(10);
        }

        @Override
        public void run() {
            try {
                this.mainLoop();
            }
            finally {
                this.lock.lock();
                try {
                    this.newTasksMayBeScheduled = false;
                    this.queue.clear();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void mainLoop() {
            while (this.newTasksMayBeScheduled) {
                SimpleTimerTask firedTask;
                this.lock.lock();
                while (true) {
                    try {
                        while (this.queue.isEmpty() && this.newTasksMayBeScheduled) {
                            this.condition.await();
                        }
                        if (!this.newTasksMayBeScheduled) {
                            this.lock.unlock();
                            return;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Throwable throwable) {
                        this.lock.unlock();
                        throw throwable;
                    }
                    {
                        boolean fired;
                        SimpleTimerTask task = this.queue.getMin();
                        if (task.isCancelled()) {
                            this.queue.removeMin();
                            continue;
                        }
                        long executionTime = task.executionTime;
                        long currentTime = this.clock.millis();
                        boolean bl = fired = executionTime <= currentTime;
                        if (fired) {
                            this.queue.removeMin();
                            if (!task.execute()) continue;
                            firedTask = task;
                            break;
                        }
                        this.condition.await(executionTime - currentTime, TimeUnit.MILLISECONDS);
                    }
                }
                this.lock.unlock();
                firedTask.run();
            }
            return;
        }
    }
}

