/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot.mercury.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import xyz.gianlu.librespot.mercury.model.SpotifyId;

public final class PlaylistId
implements SpotifyId {
    private static final Pattern PATTERN = Pattern.compile("spotify:user:(.*):playlist:(.{22})");
    public final String username;
    public final String playlistId;

    private PlaylistId(@NotNull String username, @NotNull String playlistId) {
        this.username = username;
        this.playlistId = playlistId;
    }

    @NotNull
    public static PlaylistId fromUri(@NotNull String uri) {
        Matcher matcher = PATTERN.matcher(uri);
        if (matcher.find()) {
            return new PlaylistId(matcher.group(1), matcher.group(2));
        }
        throw new IllegalArgumentException("Not a Spotify playlist ID: " + uri);
    }

    @NotNull
    public String toMercuryUri(boolean annotate) {
        if (annotate) {
            return String.format("hm://playlist-annotate/v1/annotation/user/%s/playlist/%s", this.username, this.playlistId);
        }
        return String.format("hm://playlist/user/%s/playlist/%s", this.username, this.playlistId);
    }

    @Override
    @NotNull
    public String toSpotifyUri() {
        return String.format("spotify:user:%s:playlist:%s", this.username, this.playlistId);
    }
}

