/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot.crypto;

import java.math.BigInteger;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import xyz.gianlu.librespot.common.Utils;

public class DiffieHellman {
    private static final BigInteger GENERATOR = BigInteger.valueOf(2L);
    private static final byte[] PRIME_BYTES = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -55, 15, -38, -94, 33, 104, -62, 52, -60, -58, 98, -117, -128, -36, 28, -47, 41, 2, 78, 8, -118, 103, -52, 116, 2, 11, -66, -90, 59, 19, -101, 34, 81, 74, 8, 121, -114, 52, 4, -35, -17, -107, 25, -77, -51, 58, 67, 27, 48, 43, 10, 109, -14, 95, 20, 55, 79, -31, 53, 109, 109, 81, -62, 69, -28, -123, -75, 118, 98, 94, 126, -58, -12, 76, 66, -23, -90, 58, 54, 32, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final BigInteger PRIME = new BigInteger(1, PRIME_BYTES);
    private final BigInteger privateKey;
    private final BigInteger publicKey;

    public DiffieHellman(Random random) {
        byte[] keyData = new byte[95];
        random.nextBytes(keyData);
        this.privateKey = new BigInteger(1, keyData);
        this.publicKey = GENERATOR.modPow(this.privateKey, PRIME);
    }

    @NotNull
    public BigInteger computeSharedKey(byte[] remoteKeyBytes) {
        BigInteger remoteKey = new BigInteger(1, remoteKeyBytes);
        return remoteKey.modPow(this.privateKey, PRIME);
    }

    @NotNull
    public BigInteger privateKey() {
        return this.privateKey;
    }

    @NotNull
    public BigInteger publicKey() {
        return this.publicKey;
    }

    @NotNull
    public byte[] publicKeyArray() {
        return Utils.toByteArray((BigInteger)this.publicKey);
    }
}

