/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ApResolver {
    private static final String BASE_URL = "http://apresolve.spotify.com/";
    private static final Map<String, List<String>> pool = new HashMap<String, List<String>>(3);
    private static final Logger LOGGER = Logger.getLogger(ApResolver.class);
    private static volatile boolean poolReady = false;

    public static void fillPool() throws IOException {
        if (!poolReady) {
            ApResolver.request("accesspoint", "dealer", "spclient");
        }
    }

    @NotNull
    private static List<String> getUrls(@NotNull JsonObject body, @NotNull String type) {
        JsonArray aps = body.getAsJsonArray(type);
        ArrayList<String> list = new ArrayList<String>(aps.size());
        for (JsonElement ap : aps) {
            list.add(ap.getAsString());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Map<String, List<String>> request(String ... types) throws IOException {
        if (types.length == 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder url = new StringBuilder("http://apresolve.spotify.com/?");
        for (int i = 0; i < types.length; ++i) {
            if (i != 0) {
                url.append("&");
            }
            url.append("type=").append(types[i]);
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(url.toString()).openConnection();
        conn.connect();
        try {
            JsonObject obj = JsonParser.parseReader(new InputStreamReader(conn.getInputStream())).getAsJsonObject();
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            for (String type : types) {
                map.put(type, ApResolver.getUrls(obj, type));
            }
            Map<String, List<String>> map2 = pool;
            synchronized (map2) {
                pool.putAll(map);
                poolReady = true;
                pool.notifyAll();
            }
            LOGGER.info("Loaded aps into pool: " + pool.toString());
            HashMap<String, List<String>> hashMap = map;
            return hashMap;
        }
        finally {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForPool() {
        if (!poolReady) {
            Map<String, List<String>> map = pool;
            synchronized (map) {
                try {
                    pool.wait();
                }
                catch (InterruptedException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
    }

    @NotNull
    private static String getRandomOf(@NotNull String type) {
        ApResolver.waitForPool();
        List<String> urls = pool.get(type);
        if (urls == null || urls.isEmpty()) {
            throw new IllegalStateException();
        }
        return urls.get(ThreadLocalRandom.current().nextInt(urls.size()));
    }

    @NotNull
    public static String getRandomAccesspoint() {
        return ApResolver.getRandomOf("accesspoint");
    }
}

