/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot.common;

import java.io.Closeable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AsyncWorker<T>
implements Closeable,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(AsyncWorker.class);
    private final Thread thread;
    private final BlockingQueue<T> internalQueue;
    private final String name;
    private final Consumer<T> consumer;
    private volatile boolean running = true;

    public AsyncWorker(@NotNull String name, @NotNull Consumer<T> consumer) {
        this.name = name;
        this.consumer = consumer;
        this.internalQueue = new LinkedBlockingQueue<T>();
        this.thread = new Thread((Runnable)this, name);
        this.thread.start();
    }

    public void submit(@NotNull T task) {
        this.internalQueue.add(task);
    }

    @Override
    public void close() {
        this.running = false;
        this.thread.interrupt();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                T polled = this.internalQueue.take();
                this.consumer.accept(polled);
            }
            catch (InterruptedException interruptedException) {}
        }
        LOGGER.trace(String.format("AsyncWorker{%s} is shutting down", this.name));
    }
}

