/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot;

import com.spotify.Keyexchange;
import org.jetbrains.annotations.NotNull;

public class Version {
    private static final String VERSION;
    private static final String OS;

    @NotNull
    public static Keyexchange.Platform platform() {
        if (OS.contains("win")) {
            return Keyexchange.Platform.PLATFORM_WIN32_X86;
        }
        if (OS.contains("mac")) {
            return Keyexchange.Platform.PLATFORM_OSX_X86;
        }
        return Keyexchange.Platform.PLATFORM_LINUX_X86;
    }

    @NotNull
    public static String versionNumber() {
        return VERSION;
    }

    @NotNull
    public static String versionString() {
        return "librespot-java " + VERSION;
    }

    @NotNull
    public static String systemInfoString() {
        return Version.versionString() + "; Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name");
    }

    @NotNull
    public static Keyexchange.BuildInfo standardBuildInfo() {
        return Keyexchange.BuildInfo.newBuilder().setProduct(Keyexchange.Product.PRODUCT_CLIENT).addProductFlags(Keyexchange.ProductFlags.PRODUCT_FLAG_NONE).setPlatform(Version.platform()).setVersion(117300517L).build();
    }

    static {
        OS = System.getProperty("os.name").toLowerCase();
        Package pkg = Package.getPackage("xyz.gianlu.librespot");
        String version = pkg.getImplementationVersion();
        if (version == null) {
            version = pkg.getSpecificationVersion();
        }
        VERSION = version != null ? version : "?.?.?";
    }
}

