/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot.crypto;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import xyz.gianlu.librespot.common.Utils;
import xyz.gianlu.librespot.crypto.Packet;
import xyz.gianlu.librespot.crypto.Shannon;

public class CipherPair {
    private final Shannon sendCipher = new Shannon();
    private final Shannon recvCipher;
    private final AtomicInteger sendNonce;
    private final AtomicInteger recvNonce;

    public CipherPair(byte[] sendKey, byte[] recvKey) {
        this.sendCipher.key(sendKey);
        this.sendNonce = new AtomicInteger(0);
        this.recvCipher = new Shannon();
        this.recvCipher.key(recvKey);
        this.recvNonce = new AtomicInteger(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEncoded(OutputStream out, byte cmd, byte[] payload) throws IOException {
        Shannon shannon = this.sendCipher;
        synchronized (shannon) {
            this.sendCipher.nonce(Utils.toByteArray((int)this.sendNonce.getAndIncrement()));
            ByteBuffer buffer = ByteBuffer.allocate(3 + payload.length);
            buffer.put(cmd).putShort((short)payload.length).put(payload);
            byte[] bytes = buffer.array();
            this.sendCipher.encrypt(bytes);
            byte[] mac = new byte[4];
            this.sendCipher.finish(mac);
            out.write(bytes);
            out.write(mac);
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Packet receiveEncoded(DataInputStream in) throws IOException, GeneralSecurityException {
        Shannon shannon = this.recvCipher;
        synchronized (shannon) {
            this.recvCipher.nonce(Utils.toByteArray((int)this.recvNonce.getAndIncrement()));
            byte[] headerBytes = new byte[3];
            in.readFully(headerBytes);
            this.recvCipher.decrypt(headerBytes);
            byte cmd = headerBytes[0];
            short payloadLength = (short)(headerBytes[1] << 8 | headerBytes[2] & 0xFF);
            byte[] payloadBytes = new byte[payloadLength];
            in.readFully(payloadBytes);
            this.recvCipher.decrypt(payloadBytes);
            byte[] mac = new byte[4];
            in.readFully(mac);
            byte[] expectedMac = new byte[4];
            this.recvCipher.finish(expectedMac);
            if (!Arrays.equals(mac, expectedMac)) {
                throw new GeneralSecurityException("MACs don't match!");
            }
            return new Packet(cmd, payloadBytes);
        }
    }
}

